/*!---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
"use strict";
var path_1 = require("path");
exports.WATSON_LINE_BREAK = "\r\n";
(function (pathMode) {
    pathMode[pathMode["windows"] = 0] = "windows";
    pathMode[pathMode["posix"] = 1] = "posix";
    pathMode[pathMode["defaultMode"] = 2] = "defaultMode";
})(exports.pathMode || (exports.pathMode = {}));
var pathMode = exports.pathMode;
function convertPathToPosix(input) {
    input = replaceAll(input, "\\", "/");
    var networkPath = input.startsWith("//");
    if (!networkPath) {
        var driveLetterRX = /^([a-zA-Z]):/;
        input = input.replace(driveLetterRX, "/$1");
    }
    input = path_1.posix.normalize(input);
    if (networkPath) {
        input = "/" + input;
    }
    return input;
}
exports.convertPathToPosix = convertPathToPosix;
function convertPathToWindows(input) {
    input = replaceAll(input, "/", "\\");
    var networkPath = input.startsWith("\\\\");
    if (input.startsWith("\\") && !networkPath) {
        var driveLetterRX = /^\\([a-zA-Z])\\/;
        var match = input.match(driveLetterRX);
        if (match) {
            input = input.replace(driveLetterRX, match[1] + ":\\");
        }
        else {
            input = "A:" + input;
        }
    }
    input = path_1.win32.normalize(input);
    return input;
}
exports.convertPathToWindows = convertPathToWindows;
function replaceAll(input, find, replace) {
    if (!find) {
        return input;
    }
    if (find === replace) {
        return input;
    }
    if (replace.includes(find)) {
        throw new Error("replacement string includes the search string. This will send you into an infinite loop.");
    }
    while (input.includes(find)) {
        input = input.replace(find, replace);
    }
    return input;
}
exports.replaceAll = replaceAll;
var SEM_VER = /^(\d+\.\d+\.\d+(?:\.\d+)?)(?:-([A-Za-z0-9\.\-]+))?(?:\+([A-Za-z0-9\.\-]+))?$/;
var MAIN = 1;
var TAG = 2;
var DATE_YYYYMMDD = /\d{4}(\d{4})/;
function convertVersion(input) {
    var match = input.match(SEM_VER);
    if (match) {
        var release = match[MAIN];
        if (release.split(".").length === 4) {
            return release;
        }
        var finalNumber = ".";
        var tag = match[TAG];
        if (tag) {
            var tagComponents = tag.split(".");
            if (tagComponents.length !== 0) {
                var date = tagComponents[0].match(DATE_YYYYMMDD);
                if (date) {
                    finalNumber += date[1];
                }
                var lastIndex = tagComponents.length - 1;
                if (!Number.isNaN(Number.parseInt(tagComponents[lastIndex]))) {
                    finalNumber += tagComponents[lastIndex];
                }
            }
        }
        if (finalNumber !== ".") {
            return release + finalNumber;
        }
        else {
            return release;
        }
    }
    else {
        return replaceAll(input, "_", "-");
    }
}
exports.convertVersion = convertVersion;

// SIG // Begin signature block
// SIG // MIIh6AYJKoZIhvcNAQcCoIIh2TCCIdUCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // 2h49STY+PunSOKrvRqSgq/wD+33RNPUO/xiepDtmpeSg
// SIG // gguEMIIFDDCCA/SgAwIBAgITMwAAAU/nxmLJRvSpfwAA
// SIG // AAABTzANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDEwMB4XDTE2MTExNzIxNTkxNFoX
// SIG // DTE4MDIxNzIxNTkxNFowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBALSJkIp2DKzFPaG8gejXUAi7
// SIG // WmmnrsfMuFu9OA8hUUYII9G9Iplztyjv9werK/lI96UU
// SIG // BalNJBttYZacg50zwCx5mfBd8+zVRN+lzVn6dq0GP8ZK
// SIG // A+bqLZQQwmZv/WLQUIrRIpEjl2U0ocSaAl6S4rh8KHjC
// SIG // XuNG98rvOFeIrFYGWMqYG8eo1142rppFMOO2tz0Ywqcn
// SIG // sHlNU9gy5najUCr2P7q7QR4khk2Ym3qe9izivJBgZfuW
// SIG // afrgE2jiiSoudRidwm24IfSZXip/MaCnDczvTxFu/klC
// SIG // TmHeN8srnkDvzqtecAhzpXJ7t0bOWzJTXYo5UW+w16h4
// SIG // 3aMob17uQh8CAwEAAaOCAXswggF3MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjc9BgEGCCsGAQUFBwMDMB0GA1UdDgQWBBSS
// SIG // DqERcbYvVQ3DD/TJXHQuWgxqvzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwODY1
// SIG // K2I0YjEyODc4LWUyOTMtNDNlOS1iMjFlLTdkMzA3MTlk
// SIG // NDUyZjAfBgNVHSMEGDAWgBTm/F97uyIAWORyTrX0IXQj
// SIG // MubvrDBWBgNVHR8ETzBNMEugSaBHhkVodHRwOi8vY3Js
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9N
// SIG // aWNDb2RTaWdQQ0FfMjAxMC0wNy0wNi5jcmwwWgYIKwYB
// SIG // BQUHAQEETjBMMEoGCCsGAQUFBzAChj5odHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY0NvZFNp
// SIG // Z1BDQV8yMDEwLTA3LTA2LmNydDAMBgNVHRMBAf8EAjAA
// SIG // MA0GCSqGSIb3DQEBCwUAA4IBAQARwLlqQzX+hbE4gA24
// SIG // dHUsjXFJuDxB7S294gY2kHYrieW2gemG4xiMlpMyQqen
// SIG // 9rc0JTnQxnpD6tt3cMzU6ULrqMVVAnV4ntgQvgcbypRj
// SIG // +zwPce7UVWfXKfZqvwe85Y+C6vih4nMzPxSSXqG6ZVc3
// SIG // RYWAXNYsxos8aoejBxHL7NlxOCA1JD1UvcxVifR3EJvl
// SIG // maoPrsY8jp/aAE/PfeGzwCD3UjH3IkjVYY1/JgIZfYPM
// SIG // YZMq3bjc4gizp9/hBHdgyPSsNcsx5Wx1UcU3exNqTpVr
// SIG // j0CeyE0+rr1ZxSDWwnitt2RbO9DAFXA0FOXFnqYcx/T/
// SIG // 9stIweKN827OqrSgMIIGcDCCBFigAwIBAgIKYQxSTAAA
// SIG // AAAAAzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMC
// SIG // VVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcT
// SIG // B1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jw
// SIG // b3JhdGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3Qg
// SIG // Q2VydGlmaWNhdGUgQXV0aG9yaXR5IDIwMTAwHhcNMTAw
// SIG // NzA2MjA0MDE3WhcNMjUwNzA2MjA1MDE3WjB+MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQg
// SIG // Q29kZSBTaWduaW5nIFBDQSAyMDEwMIIBIjANBgkqhkiG
// SIG // 9w0BAQEFAAOCAQ8AMIIBCgKCAQEA6Q5kUHlntcTj/QkA
// SIG // TJ6UrPdWaOpE2M/FWE+ppXZ8bUW60zmStKQe+fllguQX
// SIG // 0o/9RJwI6GWTzixVhL99COMuK6hBKxi3oktuSUxrFQfe
// SIG // 0dLCiR5xlM21f0u0rwjYzIjWaxeUOpPOJj/s5v40mFfV
// SIG // HV1J9rIqLtWFu1k/+JC0K4N0yiuzO0bj8EZJwRdmVMkc
// SIG // vR3EVWJXcvhnuSUgNN5dpqWVXqsogM3Vsp7lA7Vj07IU
// SIG // yMHIiiYKWX8H7P8O7YASNUwSpr5SW/Wm2uCLC0h31oVH
// SIG // 1RC5xuiq7otqLQVcYMa0KlucIxxfReMaFB5vN8sZM4Bq
// SIG // iU2jamZjeJPVMM+VHwIDAQABo4IB4zCCAd8wEAYJKwYB
// SIG // BAGCNxUBBAMCAQAwHQYDVR0OBBYEFOb8X3u7IgBY5HJO
// SIG // tfQhdCMy5u+sMBkGCSsGAQQBgjcUAgQMHgoAUwB1AGIA
// SIG // QwBBMAsGA1UdDwQEAwIBhjAPBgNVHRMBAf8EBTADAQH/
// SIG // MB8GA1UdIwQYMBaAFNX2VsuP6KJcYmjRPZSQW9fOmhjE
// SIG // MFYGA1UdHwRPME0wS6BJoEeGRWh0dHA6Ly9jcmwubWlj
// SIG // cm9zb2Z0LmNvbS9wa2kvY3JsL3Byb2R1Y3RzL01pY1Jv
// SIG // b0NlckF1dF8yMDEwLTA2LTIzLmNybDBaBggrBgEFBQcB
// SIG // AQROMEwwSgYIKwYBBQUHMAKGPmh0dHA6Ly93d3cubWlj
// SIG // cm9zb2Z0LmNvbS9wa2kvY2VydHMvTWljUm9vQ2VyQXV0
// SIG // XzIwMTAtMDYtMjMuY3J0MIGdBgNVHSAEgZUwgZIwgY8G
// SIG // CSsGAQQBgjcuAzCBgTA9BggrBgEFBQcCARYxaHR0cDov
// SIG // L3d3dy5taWNyb3NvZnQuY29tL1BLSS9kb2NzL0NQUy9k
// SIG // ZWZhdWx0Lmh0bTBABggrBgEFBQcCAjA0HjIgHQBMAGUA
// SIG // ZwBhAGwAXwBQAG8AbABpAGMAeQBfAFMAdABhAHQAZQBt
// SIG // AGUAbgB0AC4gHTANBgkqhkiG9w0BAQsFAAOCAgEAGnTv
// SIG // V08pe8QWhXi4UNMi/AmdrIKX+DT/KiyXlRLl5L/Pv5PI
// SIG // 4zSp24G43B4AvtI1b6/lf3mVd+UC1PHr2M1OHhthosJa
// SIG // IxrwjKhiUUVnCOM/PB6T+DCFF8g5QKbXDrMhKeWloWmM
// SIG // IpPMdJjnoUdD8lOswA8waX/+0iUgbW9h098H1dlyACxp
// SIG // hnY9UdumOUjJN2FtB91TGcun1mHCv+KDqw/ga5uV1n0o
// SIG // UbCJSlGkmmzItx9KGg5pqdfcwX7RSXCqtq27ckdjF/qm
// SIG // 1qKmhuyoEESbY7ayaYkGx0aGehg/6MUdIdV7+QIjLcVB
// SIG // y78dTMgW77Gcf/wiS0mKbhXjpn92W9FTeZGFndXS2z1z
// SIG // NfM8rlSyUkdqwKoTldKOEdqZZ14yjPs3hdHcdYWch8Za
// SIG // V4XCv90Nj4ybLeu07s8n07VeafqkFgQBpyRnc89NT7be
// SIG // BVaXevfpUk30dwVPhcbYC/GO7UIJ0Q124yNWeCImNr7K
// SIG // sYxuqh3khdpHM2KPpMmRM19xHkCvmGXJIuhCISWKHC1g
// SIG // 2TeJQYkqFg/XYTyUaGBS79ZHmaCAQO4VgXc+nOBTGBpQ
// SIG // HTiVmx5mMxMnORd4hzbOTsNfsvU9R1O24OXbC2E9KteS
// SIG // LM43Wj5AQjGkHxAIwlacvyRdUQKdannSF9PawZSOB3sl
// SIG // cUSrBmrm1MbfI5qWdcUxghW8MIIVuAIBATCBlTB+MQsw
// SIG // CQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQ
// SIG // MA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9z
// SIG // b2Z0IENvcnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3Nv
// SIG // ZnQgQ29kZSBTaWduaW5nIFBDQSAyMDEwAhMzAAABT+fG
// SIG // YslG9Kl/AAAAAAFPMA0GCWCGSAFlAwQCAQUAoIGoMBkG
// SIG // CSqGSIb3DQEJAzEMBgorBgEEAYI3AgEEMBwGCisGAQQB
// SIG // gjcCAQsxDjAMBgorBgEEAYI3AgEVMC8GCSqGSIb3DQEJ
// SIG // BDEiBCA+wpMd/81Hg5o5uNJztAKAs/JgyFDZE64Afv7s
// SIG // Yo6ErzA8BgorBgEEAYI3AgEMMS4wLKASgBAAdQB0AGkA
// SIG // bABzAC4AagBzoRaAFGh0dHA6Ly9taWNyb3NvZnQuY29t
// SIG // MA0GCSqGSIb3DQEBAQUABIIBACvzLdzArY2ehveE/4Sj
// SIG // 22mSildsLaJ3XqvgTicBfH5iXQYIAt7s7ufd2durfHCo
// SIG // RiMM9csLom7UzqbGj/Eb4sKi8hZ0bw++tze/1jJiX0xl
// SIG // d+y2NMrDB/GhrpraZxaLqSmiGcAPTrKMTYyuKlRs/56J
// SIG // kTsZOo4H83OzmkEbPIGG3/WGm0Er+1jeL2CWLv8S8rQK
// SIG // bf4mmK0yOjs1IkLC93tgjChqSMezBku5RAmBaQSYJFDa
// SIG // wVXp58sp+glXG7RY1t+8pITimMYsReJqSpzT4GmSaLmv
// SIG // w95loxKc1FmGU/DrgFaGXMOpd9A874f4P90lX2TMihi3
// SIG // OPlGd2HdKICow3ihghNMMIITSAYKKwYBBAGCNwMDATGC
// SIG // EzgwghM0BgkqhkiG9w0BBwKgghMlMIITIQIBAzEPMA0G
// SIG // CWCGSAFlAwQCAQUAMIIBPAYLKoZIhvcNAQkQAQSgggEr
// SIG // BIIBJzCCASMCAQEGCisGAQQBhFkKAwEwMTANBglghkgB
// SIG // ZQMEAgEFAAQgujuvMrubBzZ0otHwgccLgwVAgCAdEn54
// SIG // JmlBJg2pIPACBlg/QcsqpRgSMjAxNjEyMjgwMDU4MDAu
// SIG // NjhaMAcCAQGAAgH0oIG5pIG2MIGzMQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQLEx5u
// SIG // Q2lwaGVyIERTRSBFU046QkJFQy0zMENBLTJEQkUxJTAj
// SIG // BgNVBAMTHE1pY3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZp
// SIG // Y2Wggg7QMIIGcTCCBFmgAwIBAgIKYQmBKgAAAAAAAjAN
// SIG // BgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMxEzAR
// SIG // BgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1v
// SIG // bmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlv
// SIG // bjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2VydGlm
// SIG // aWNhdGUgQXV0aG9yaXR5IDIwMTAwHhcNMTAwNzAxMjEz
// SIG // NjU1WhcNMjUwNzAxMjE0NjU1WjB8MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSYwJAYDVQQDEx1NaWNyb3NvZnQgVGltZS1T
// SIG // dGFtcCBQQ0EgMjAxMDCCASIwDQYJKoZIhvcNAQEBBQAD
// SIG // ggEPADCCAQoCggEBAKkdDbx3EYo6IOz8E5f1+n9plGt0
// SIG // VBDVpQoAgoX77XxoSyxfxcPlYcJ2tz5mK1vwFVMnBDEf
// SIG // QRsalR3OCROOfGEwWbEwRA/xYIiEVEMM1024OAizQt2T
// SIG // rNZzMFcmgqNFDdDq9UeBzb8kYDJYYEbyWEeGMoQedGFn
// SIG // kV+BVLHPk0ySwcSmXdFhE24oxhr5hoC732H8RsEnHSRn
// SIG // EnIaIYqvS2SJUGKxXf13Hz3wV3WsvYpCTUBR0Q+cBj5n
// SIG // f/VmwAOWRH7v0Ev9buWayrGo8noqCjHw2k4GkbaICDXo
// SIG // eByw6ZnNPOcvRLqn9NxkvaQBwSAJk3jN/LzAyURdXhac
// SIG // AQVPIk0CAwEAAaOCAeYwggHiMBAGCSsGAQQBgjcVAQQD
// SIG // AgEAMB0GA1UdDgQWBBTVYzpcijGQ80N7fEYbxTNoWoVt
// SIG // VTAZBgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNV
// SIG // HQ8EBAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSME
// SIG // GDAWgBTV9lbLj+iiXGJo0T2UkFvXzpoYxDBWBgNVHR8E
// SIG // TzBNMEugSaBHhkVodHRwOi8vY3JsLm1pY3Jvc29mdC5j
// SIG // b20vcGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXRf
// SIG // MjAxMC0wNi0yMy5jcmwwWgYIKwYBBQUHAQEETjBMMEoG
// SIG // CCsGAQUFBzAChj5odHRwOi8vd3d3Lm1pY3Jvc29mdC5j
// SIG // b20vcGtpL2NlcnRzL01pY1Jvb0NlckF1dF8yMDEwLTA2
// SIG // LTIzLmNydDCBoAYDVR0gAQH/BIGVMIGSMIGPBgkrBgEE
// SIG // AYI3LgMwgYEwPQYIKwYBBQUHAgEWMWh0dHA6Ly93d3cu
// SIG // bWljcm9zb2Z0LmNvbS9QS0kvZG9jcy9DUFMvZGVmYXVs
// SIG // dC5odG0wQAYIKwYBBQUHAgIwNB4yIB0ATABlAGcAYQBs
// SIG // AF8AUABvAGwAaQBjAHkAXwBTAHQAYQB0AGUAbQBlAG4A
// SIG // dAAuIB0wDQYJKoZIhvcNAQELBQADggIBAAfmiFEN4sbg
// SIG // mD+BcQM9naOhIW+z66bM9TG+zwXiqf76V20ZMLPCxWbJ
// SIG // at/15/B4vceoniXj+bzta1RXCCtRgkQS+7lTjMz0YBKK
// SIG // dsxAQEGb3FwX/1z5Xhc1mCRWS3TvQhDIr79/xn/yN31a
// SIG // PxzymXlKkVIArzgPF/UveYFl2am1a+THzvbKegBvSzBE
// SIG // JCI8z+0DpZaPWSm8tv0E4XCfMkon/VWvL/625Y4zu2Jf
// SIG // mttXQOnxzplmkIz/amJ/3cVKC5Em4jnsGUpxY517IW3D
// SIG // nKOiPPp/fZZqkHimbdLhnPkd/DjYlPTGpQqWhqS9nhqu
// SIG // BEKDuLWAmyI4ILUl5WTs9/S/fmNZJQ96LjlXdqJxqgaK
// SIG // D4kWumGnEcua2A5HmoDF0M2n0O99g/DhO3EJ3110mCII
// SIG // YdqwUB5vvfHhAN/nMQekkzr3ZUd46PioSKv33nJ+YWtv
// SIG // d6mBy6cJrDm77MbL2IK0cs0d9LiFAR6A+xuJKlQ5slva
// SIG // yA1VmXqHczsI5pgt6o3gMy4SKfXAL1QnIffIrE7aKLix
// SIG // qduWsqdCosnPGUFN4Ib5KpqjEWYw07t0MkvfY3v1mYov
// SIG // G8chr1m1rtxEPJdQcdeh0sVV42neV8HR3jDA/czmTfsN
// SIG // v11P6Z0eGTgvvM9YBS7vDaBQNdrvCScc1bN+NR4Iuto2
// SIG // 29Nfj950iEkSMIIE2jCCA8KgAwIBAgITMwAAAKGl/bnu
// SIG // p/yenQAAAAAAoTANBgkqhkiG9w0BAQsFADB8MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSYwJAYDVQQDEx1NaWNyb3NvZnQg
// SIG // VGltZS1TdGFtcCBQQ0EgMjAxMDAeFw0xNjA5MDcxNzU2
// SIG // NDhaFw0xODA5MDcxNzU2NDhaMIGzMQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQLEx5u
// SIG // Q2lwaGVyIERTRSBFU046QkJFQy0zMENBLTJEQkUxJTAj
// SIG // BgNVBAMTHE1pY3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZp
// SIG // Y2UwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
// SIG // AQCb0AF55iKvenwbdR7zt2fWHd6n3gA02BL5B+oIex9N
// SIG // TcqFlHqrdmsqB0WNUSfTtl1GpSXGYhR5i0/M5iz17J9N
// SIG // eh00IjYquMPi7MVQ7dP9Q8Etv8Xw+s/MhJDroqaybVeg
// SIG // j7lhcNRJzogvgy47gUqTtUlKxGXJloXkL/qs4thXHTP2
// SIG // vhDnwlIbE+D5FDaos5v02xXw9NJrfS24Vc4R6Vb/lOkh
// SIG // DruRV8ycFXlwzY6s0+OBmZjDDgff23PFzylj9T7sNxh6
// SIG // c/YkdbX8yTeUMFcH1aBAFU0LFrDm1TddPNjTq7yHl4d6
// SIG // VXNLYUPB8wmIkr7OuOWESjwWN5xBziCXgcgJAgMBAAGj
// SIG // ggEbMIIBFzAdBgNVHQ4EFgQUq1y5gr5xKtWP4OiyKc/6
// SIG // G9O3+kgwHwYDVR0jBBgwFoAU1WM6XIoxkPNDe3xGG8Uz
// SIG // aFqFbVUwVgYDVR0fBE8wTTBLoEmgR4ZFaHR0cDovL2Ny
// SIG // bC5taWNyb3NvZnQuY29tL3BraS9jcmwvcHJvZHVjdHMv
// SIG // TWljVGltU3RhUENBXzIwMTAtMDctMDEuY3JsMFoGCCsG
// SIG // AQUFBwEBBE4wTDBKBggrBgEFBQcwAoY+aHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNUaW1T
// SIG // dGFQQ0FfMjAxMC0wNy0wMS5jcnQwDAYDVR0TAQH/BAIw
// SIG // ADATBgNVHSUEDDAKBggrBgEFBQcDCDANBgkqhkiG9w0B
// SIG // AQsFAAOCAQEAI2BMuAVU6WfJvjk8FTLDE8izAJB/FzOb
// SIG // /XYvXUwSs+iwJKL+svQfqLKOLk4QB1zo9zSK7jQd6OFE
// SIG // hvge2949EpSHwZoPQ+Cb+hRhq7bqEuOqiGrXZXflB1vQ
// SIG // UFPRxVrUKC8qSlF5H3k5KnfHYeUjfyoF2iae1UC24l/c
// SIG // OhN05Tr9qvs/Avwr+fggUlsoyl2yICjuHR70ioS8F1Lq
// SIG // sxJxmiwdG04NeNHbkw0kXheISVQh/NhcJtDpE+Fsyk6/
// SIG // B7g7+eGcL0YMZTqcRbAJp3NMLGu21xZj4PxyOJmmBc0y
// SIG // kUGiXvq7160Oe4XL8w93O3gy00+WkRRII8aKl5dYHf2l
// SIG // QaGCA3kwggJhAgEBMIHjoYG5pIG2MIGzMQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQL
// SIG // Ex5uQ2lwaGVyIERTRSBFU046QkJFQy0zMENBLTJEQkUx
// SIG // JTAjBgNVBAMTHE1pY3Jvc29mdCBUaW1lLVN0YW1wIFNl
// SIG // cnZpY2WiJQoBATAJBgUrDgMCGgUAAxUAgq6J9bTmPxZc
// SIG // ILwX5MHDQM0562iggcIwgb+kgbwwgbkxCzAJBgNVBAYT
// SIG // AlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQH
// SIG // EwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29y
// SIG // cG9yYXRpb24xDTALBgNVBAsTBE1PUFIxJzAlBgNVBAsT
// SIG // Hm5DaXBoZXIgTlRTIEVTTjo1N0Y2LUMxRTAtNTU0QzEr
// SIG // MCkGA1UEAxMiTWljcm9zb2Z0IFRpbWUgU291cmNlIE1h
// SIG // c3RlciBDbG9jazANBgkqhkiG9w0BAQUFAAIFANwNhT4w
// SIG // IhgPMjAxNjEyMjgwMDI2MzhaGA8yMDE2MTIyOTAwMjYz
// SIG // OFowdzA9BgorBgEEAYRZCgQBMS8wLTAKAgUA3A2FPgIB
// SIG // ADAKAgEAAgIBFAIB/zAHAgEAAgIa/jAKAgUA3A7WvgIB
// SIG // ADA2BgorBgEEAYRZCgQCMSgwJjAMBgorBgEEAYRZCgMB
// SIG // oAowCAIBAAIDFuNgoQowCAIBAAIDB6EgMA0GCSqGSIb3
// SIG // DQEBBQUAA4IBAQDNbzKPpGOELvF2MG+hdKXjDjhHYP4Q
// SIG // cpyf77Ah4+lKRn+YPAveRXRI8YfLT6Xk0WgRul/roLtG
// SIG // W7yJ+bC/bKE6FHMPRKngSSC8U1T5ub5l14GB0A/xUXv2
// SIG // ceSwzTwVThQRMg1p4VL9loD1QVCXUMcS9XQoUVcZGGL/
// SIG // iEuQiX+3s4ZB7HHjA0NKufF3DR6PqI8zKqXfMKo+aHoA
// SIG // JvDzxxIYXVzMY/a4/uZg7NV9CI6JjMd7doNUY9ONJRT3
// SIG // SuzX6pqFRIeH6/KFkr6UJy3yXKrHG5QidAP56GI5ORTX
// SIG // UpN88J1BrucPfVKN97mAiJ9QElvbwObBQfP4czyynlR6
// SIG // zOdzMYIC9TCCAvECAQEwgZMwfDELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEmMCQGA1UEAxMdTWljcm9zb2Z0IFRpbWUtU3Rh
// SIG // bXAgUENBIDIwMTACEzMAAAChpf257qf8np0AAAAAAKEw
// SIG // DQYJYIZIAWUDBAIBBQCgggEyMBoGCSqGSIb3DQEJAzEN
// SIG // BgsqhkiG9w0BCRABBDAvBgkqhkiG9w0BCQQxIgQgZmME
// SIG // piqDY+Ax02VYSi1HugTQxWptCldwrD2p0Rfrr+kwgeIG
// SIG // CyqGSIb3DQEJEAIMMYHSMIHPMIHMMIGxBBSCron1tOY/
// SIG // FlwgvBfkwcNAzTnraDCBmDCBgKR+MHwxCzAJBgNVBAYT
// SIG // AlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQH
// SIG // EwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29y
// SIG // cG9yYXRpb24xJjAkBgNVBAMTHU1pY3Jvc29mdCBUaW1l
// SIG // LVN0YW1wIFBDQSAyMDEwAhMzAAAAoaX9ue6n/J6dAAAA
// SIG // AAChMBYEFEtXhZ9d7pA2/2JCeJ6TcrdD/2oxMA0GCSqG
// SIG // SIb3DQEBCwUABIIBAITPSOoFyiXNhs4u72oUmyIaQ414
// SIG // QoZOdkcNpLCDp4wyQf1w/cbd9Hcow4P/FkLMsTL1Qu95
// SIG // XgegVW6pM0asgjVCMk6cbmDqhE6RJA2BXqeBvU78Ah5X
// SIG // 1CQW2qaAYpWOJNVNAHpdfpCSzERxmEwwgxkKHGUVYDDT
// SIG // S7cT5AyRDjUMfaDhOmJj6/h/orMNmzP9pp8Mr59lEIx6
// SIG // wc+ug8IvGYVqELd/pfWLTcioJlig3vH9wZFxFlNN2g60
// SIG // 7qy6cSNfuJ+10PXdGV5Wudx0sKHjNegGMcPpXitCmHTj
// SIG // qW590KFnPIOivSvhtzlpkZQeSIqE1K1TcEAGUYWvDqsj
// SIG // j2k/IlE=
// SIG // End signature block
